/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.MyInputStream;
import cds.aladin.PlanImage;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.BuilderMoc;
import cds.allsky.BuilderTree;
import cds.allsky.CacheFitsWriter;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import cds.fits.Fits;
import cds.fits.HeaderFits;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import javax.swing.JProgressBar;

public class BuilderMapTiles
extends Builder {
    private HeaderFits headerFits;
    private CacheFitsWriter cache;
    protected int bitpixOrig = -1;
    protected int maxOrder = -1;
    private long nside = -1L;
    private String ordering = null;
    private long initialOffsetHpx;
    private long startTime = 0L;
    private long nbRecord = -1L;
    private long cRecord = -1L;
    private String info = "";
    private Builder b = null;

    public BuilderMapTiles(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.MAPTILES;
    }

    @Override
    public void run() throws Exception {
        this.build();
        if (!this.context.isTaskAborting()) {
            this.context.resetCheckCode();
            new BuilderTree(this.context).run();
            this.context.info("HiPS TREE done");
            this.context.setProgressLastNorder3(1);
            this.b = new BuilderMoc(this.context);
            this.b.run();
        }
    }

    @Override
    public void validateContext() throws Exception {
        this.validateMap();
        this.validateOutput();
        if (this.context instanceof ContextGui) {
            JProgressBar bar = ((ContextGui)this.context).mainPanel.getProgressBarTile();
            this.context.setProgressBar(bar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateMap() throws Exception {
        String map = this.context.getInputPath();
        try (MyInputStream in = null;){
            in = new MyInputStream(new FileInputStream(map));
            this.headerFits = new HeaderFits(in);
            int naxis = this.headerFits.getIntFromHeader("NAXIS");
            if (naxis <= 1 && this.headerFits.getStringFromHeader("EXTEND") != null) {
                try {
                    int naxis1 = this.headerFits.getIntFromHeader("NAXIS1");
                    try {
                        this.nside = this.headerFits.getIntFromHeader("NSIDE");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.ordering = this.headerFits.getStringFromHeader("ORDERING");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    in.skip(naxis1);
                }
                catch (Exception naxis1) {
                    // empty catch block
                }
                in.skipOnNext2880();
                this.headerFits = new HeaderFits(in);
                this.context.setHeader(this.headerFits);
            }
            this.initialOffsetHpx = in.getPos();
            String mapFrame = this.headerFits.getStringFromHeader("COORDSYS");
            if (mapFrame == null) {
                mapFrame = "G";
            }
            int frameMap = Context.getFrameVal(mapFrame);
            if (this.context.hasFrame() && frameMap != this.context.getFrame()) {
                throw new Exception("Uncompatible coordinate frames. The input HEALPix map is [" + Context.getFrameName(frameMap) + "]");
            }
        }
    }

    private void initStat(long nbRecord) {
        this.nbRecord = nbRecord;
        this.cRecord = 0L;
        this.context.setProgressMax(nbRecord);
        this.startTime = System.currentTimeMillis();
    }

    private void updateStat(long cRecord) {
        this.cRecord = cRecord;
    }

    @Override
    public void showStatistics() {
        if (this.b != null) {
            this.b.showStatistics();
            return;
        }
        if (this.nbRecord <= 0L) {
            return;
        }
        long now = System.currentTimeMillis();
        long cTime = now - this.startTime;
        if (cTime < 2000L) {
            return;
        }
        this.context.showMapStat(this.cRecord, this.nbRecord, cTime, this.cache, this.info);
    }

    @Override
    protected void build() throws Exception {
        this.build(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void build(boolean flagSimpleLook) throws Exception {
        int tileWidth;
        int maxTileWidth;
        String s;
        int idxTForm = 0;
        String path = this.context.getOutputPath();
        long naxis1 = this.headerFits.getIntFromHeader("NAXIS1");
        long naxis2 = this.headerFits.getIntFromHeader("NAXIS2");
        int nField = this.headerFits.getIntFromHeader("TFIELDS");
        double badData = Double.NaN;
        String frame = "G";
        double bzeroOrig = 0.0;
        double bscaleOrig = 1.0;
        double blankOrig = Double.NaN;
        boolean isPartial = false;
        boolean isNested = true;
        if (this.nside == -1L) {
            this.nside = this.headerFits.getIntFromHeader("NSIDE");
        }
        try {
            badData = Double.parseDouble(this.headerFits.getStringFromHeader("BAD_DATA"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s = this.headerFits.getStringFromHeader("COORDSYS");
            if (s != null) {
                frame = s;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            bzeroOrig = this.headerFits.getDoubleFromHeader("BZERO");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            bscaleOrig = this.headerFits.getDoubleFromHeader("BSCALE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            blankOrig = this.headerFits.getDoubleFromHeader("BLANK");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String string = s = this.ordering != null ? this.ordering : this.headerFits.getStringFromHeader("ORDERING");
            if (s != null && s.equals("RING")) {
                isNested = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s = this.headerFits.getStringFromHeader("OBJECT");
            if (s != null) {
                if (s.equalsIgnoreCase("PARTIAL")) {
                    isPartial = true;
                }
            } else {
                s = this.headerFits.getStringFromHeader("TTYPE1");
                if (s.equalsIgnoreCase("PIXEL")) {
                    isPartial = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.context.setFrameName(frame);
        if (!flagSimpleLook) {
            this.context.info("HiPS coordinate frame => " + this.context.getFrameName());
        }
        if (isPartial) {
            idxTForm = 1;
        }
        this.info = "HEALPix FITS map " + (isPartial ? " PARTIAL" : "") + " nside=" + this.nside + " ordering=" + (isNested ? "NESTED" : "RING") + " frame=" + this.context.getFrameName();
        if (!flagSimpleLook) {
            this.context.info(this.info);
        }
        if (this.nside < (long)(maxTileWidth = this.context.getTileSide())) {
            maxTileWidth = (int)this.nside;
        }
        if (this.context.getOrder() == -1) {
            tileWidth = 2 * maxTileWidth;
            do {
                this.maxOrder = this.getLevelImage(this.nside, tileWidth /= 2);
            } while (this.maxOrder < 3);
        } else {
            this.maxOrder = this.context.getOrder();
            long nbPix = 12L * this.nside * this.nside;
            long nbTiles = 12L * CDSHealpix.pow2(this.maxOrder) * CDSHealpix.pow2(this.maxOrder);
            long nbPixPerTile = nbPix / nbTiles;
            tileWidth = (int)Math.sqrt(nbPixPerTile);
        }
        long nsideFile = CDSHealpix.pow2(this.maxOrder);
        if (!flagSimpleLook) {
            this.context.info("HiPS maxOrder=" + this.maxOrder + " tileWidth=" + tileWidth);
        }
        this.context.setOrder(this.maxOrder);
        int div = (int)(CDSHealpix.log2(this.nside) - CDSHealpix.log2((long)tileWidth * nsideFile)) * 2;
        char type = 'D';
        char typePixel = 'J';
        int offsetPix = 0;
        int offsetVal = 0;
        int nbValPerSegment = 1;
        int sizeRecord = 0;
        int sizeFieldVal = 8;
        int sizeFieldPix = 4;
        for (int i = 1; i <= nField; ++i) {
            String form = this.headerFits.getStringFromHeader("TFORM" + i).trim();
            if (i == idxTForm + 1) {
                type = form.charAt(form.length() - 1);
                sizeFieldVal = cds.tools.Util.binSizeOf(type, 1);
                if (form.length() > 1) {
                    nbValPerSegment = Integer.parseInt(form.substring(0, form.length() - 1));
                }
                offsetVal = sizeRecord;
            } else if (isPartial && i == 1) {
                typePixel = form.charAt(form.length() - 1);
                sizeFieldPix = cds.tools.Util.binSizeOf(typePixel, 1);
                offsetPix = sizeRecord;
            }
            sizeRecord += cds.tools.Util.binSizeOf(form);
        }
        long nbRecord = naxis1 * naxis2 / (long)sizeRecord;
        this.bitpixOrig = this.getBitpixFromFormat(type);
        if (flagSimpleLook) {
            return;
        }
        this.context.setBitpixOrig(this.bitpixOrig);
        if (this.bitpixOrig < 0 && this.context.hasAlternateBlank()) {
            badData = this.context.getBlankOrig();
        } else {
            this.context.setBlankOrig(blankOrig);
        }
        this.context.setBZeroOrig(bzeroOrig);
        this.context.setBScaleOrig(bscaleOrig);
        this.context.info("Original BITPIX=" + this.bitpixOrig + " BLANK=" + blankOrig + (!Double.isNaN(badData) ? " BAD_DATA=" + badData : "") + (bzeroOrig != 0.0 ? " BZERO=" + bzeroOrig : "") + (bscaleOrig != 1.0 ? " BSCALE=" + bscaleOrig : ""));
        double bscale = this.context.getBScale();
        double bzero = this.context.getBZero();
        double blank = this.context.getBlank();
        int bitpix = this.context.getBitpix();
        double[] pixelRangeCut = this.context.getPixelRangeCut();
        double[] cutOrig = null;
        double[] cut = null;
        int bitpixP = this.getBitpixFromFormat(typePixel);
        long nbPixPerTile = tileWidth * tileWidth;
        int tileOrder = (int)CDSHealpix.log2(tileWidth);
        int[] hpx2xy = Util.createHpx2xy(tileOrder);
        this.context.info("MAP structure: nbRecord=" + nbRecord + " nbValPerSegment=" + nbValPerSegment + " valType=" + type);
        RandomAccessFile f = null;
        Fits fits = null;
        Fits lastFits = null;
        String lastFile = "";
        long nbTiles = 12L * nsideFile * nsideFile;
        long tileMem = nbPixPerTile * (long)(Math.abs(bitpix) / 8) + 4000L;
        long reqMem = nbTiles * tileMem;
        long mem = (long)((double)this.context.getMem() * 0.75);
        if (reqMem < mem) {
            mem = reqMem;
        }
        this.context.info("Writer cache RAM=" + cds.tools.Util.getUnitDisk(mem) + " (" + mem / tileMem + " tiles)");
        this.cache = new CacheFitsWriter(mem);
        this.cache.setContext(this.context);
        int sizeBuf = 512;
        int nbRecordInBuf = sizeBuf / sizeRecord;
        if (nbRecordInBuf < 1) {
            nbRecordInBuf = 1;
        }
        sizeBuf = nbRecordInBuf * sizeRecord;
        byte[] buf = new byte[sizeBuf];
        Fits sample = null;
        int nbValInSample = 0;
        try {
            f = new RandomAccessFile(this.context.getInputPath(), "rw");
            boolean missingCut = !Context.hasCut(pixelRangeCut);
            boolean missingRange = !Context.hasRange(pixelRangeCut);
            int nbStep = missingCut || missingRange ? 2 : 1;
            int gapSample = 1;
            if (nbStep == 2) {
                int sizeVal = Math.abs(this.bitpixOrig) / 8;
                long nbPossibleVal = mem / (long)sizeVal;
                int nbVal = nbValInSample = (int)(nbRecord * (long)nbValPerSegment);
                int w = (int)Math.sqrt(nbValInSample);
                gapSample = 1;
                while ((long)nbValInSample > nbPossibleVal || w > 4096) {
                    nbValInSample = nbVal / gapSample;
                    w = (int)Math.sqrt(nbValInSample);
                    ++gapSample;
                }
                nbValInSample = w * w;
                sample = new Fits(w, w, this.bitpixOrig);
                sample.setBlank(blankOrig);
                sample.setBzero(bzeroOrig);
                sample.setBscale(bscaleOrig);
                this.context.info("Pixel dynamic estimation on " + nbValInSample + " values" + (gapSample > 1 ? " (gapSample=" + gapSample + ")" : "") + "...");
            }
            block22: for (int step = 0; step < nbStep; ++step) {
                if (step == nbStep - 1) {
                    this.initStat(nbRecord);
                    if (sample != null) {
                        this.context.initCut(sample);
                    }
                    cutOrig = this.context.getCutOrig();
                    if (Context.hasCut(pixelRangeCut)) {
                        if (cutOrig == null) {
                            cutOrig = new double[7];
                        }
                        cutOrig[0] = pixelRangeCut[0];
                        cutOrig[1] = pixelRangeCut[1];
                    }
                    if (Context.hasRange(pixelRangeCut)) {
                        if (cutOrig == null) {
                            cut = new double[7];
                        }
                        cutOrig[2] = pixelRangeCut[2];
                        cutOrig[3] = pixelRangeCut[3];
                    }
                    this.context.setCutOrig(cutOrig);
                    this.context.initParameters();
                    cut = this.context.getCut();
                    if (this.bitpixOrig != bitpix) {
                        blank = this.context.getBlank();
                        bzero = this.context.getBZero();
                        bscale = this.context.getBScale();
                    }
                    if (sample != null) {
                        sample.free();
                    }
                    this.context.setValidateCut(true);
                    this.context.info("Pixel dynamic range=[" + this.ip(cut[2], bzero, bscale) + " .. " + this.ip(cut[3], bzero, bscale) + "] cut=[" + this.ip(cut[0], bzero, bscale) + " .. " + this.ip(cut[1], bzero, bscale) + "]");
                    this.context.setTileOrder(tileOrder);
                }
                int posSample = 0;
                long count = 0L;
                int cRecordInBuf = nbRecordInBuf;
                f.seek(this.initialOffsetHpx);
                long n = 0L;
                while (n < nbRecord) {
                    if (cRecordInBuf == nbRecordInBuf) {
                        int nbytes = f.read(buf);
                        if (nbytes == -1) {
                            throw new EOFException();
                        }
                        nbRecordInBuf = nbytes / sizeRecord;
                        cRecordInBuf = 0;
                    }
                    if (this.context.isTaskAborting()) {
                        throw new Exception("Task abort !");
                    }
                    if (step == nbStep - 1) {
                        this.updateStat(n);
                    }
                    int o = (int)CDSHealpix.log2(this.nside);
                    for (int i = 0; i < nbValPerSegment; ++i) {
                        long npixFile;
                        String file;
                        double val;
                        long npix = isPartial ? BuilderMapTiles.getNpix(buf, bitpixP, offsetPix + cRecordInBuf * sizeRecord + i * sizeFieldPix) : count;
                        ++count;
                        if (!isNested) {
                            npix = CDSHealpix.ring2nest(o, npix);
                        }
                        if ((val = BuilderMapTiles.getVal(buf, this.bitpixOrig, offsetVal + cRecordInBuf * sizeRecord + i * sizeFieldVal)) == badData) {
                            val = blankOrig;
                        }
                        if (step == 0 && nbStep == 2) {
                            if (posSample >= sample.width * sample.width) continue block22;
                            if (count % (long)gapSample != 0L) continue;
                            Fits.setPixValDouble(sample.pixels, this.bitpixOrig, posSample++, val);
                            continue;
                        }
                        if (bitpix != this.bitpixOrig) {
                            double d = Double.isNaN(val) || val == blankOrig ? blank : (val <= cutOrig[2] ? cut[2] : (val = val >= cutOrig[3] ? cut[3] : (val - cutOrig[2]) * this.context.coef + cut[2]));
                            if (bitpix > 0 && (double)((long)val) == blank && val != blank) {
                                val += 0.5;
                            }
                        }
                        if (div != 0) {
                            npix >>>= div;
                        }
                        if ((file = Util.getFilePath(path, this.maxOrder, npixFile = npix / nbPixPerTile) + ".fits").equals(lastFile)) {
                            fits = lastFits;
                        } else {
                            try {
                                fits = this.cache.getFits(file);
                            }
                            catch (FileNotFoundException e) {
                                fits = new Fits(tileWidth, tileWidth, bitpix);
                                fits.setBlank(blank);
                                fits.setBzero(bzero);
                                fits.setBscale(bscale);
                                for (int y = 0; y < tileWidth; ++y) {
                                    for (int x = 0; x < tileWidth; ++x) {
                                        fits.setPixelDouble(x, y, blank);
                                    }
                                }
                                this.cache.addFits(file, fits);
                            }
                            lastFits = fits;
                        }
                        long startIdx = npixFile * (long)tileWidth * (long)tileWidth;
                        int idx = hpx2xy[(int)(npix - startIdx)];
                        Fits.setPixValDouble(fits.pixels, bitpix, idx, val);
                    }
                    ++n;
                    ++cRecordInBuf;
                }
            }
        }
        finally {
            if (f != null) {
                f.close();
            }
        }
        this.cache.close();
    }

    public static final long getNpix(byte[] t, int bitpix, int pos) {
        try {
            switch (bitpix) {
                case 8: {
                    return PlanImage.getByte(t, pos);
                }
                case 16: {
                    return PlanImage.getShort(t, pos);
                }
                case 32: {
                    return PlanImage.getInt(t, pos);
                }
                case 64: {
                    return PlanImage.getLong(t, pos);
                }
            }
            return 0L;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static final double getVal(byte[] t, int bitpix, int pos) {
        try {
            switch (bitpix) {
                case 8: {
                    return PlanImage.getByte(t, pos);
                }
                case 16: {
                    return PlanImage.getShort(t, pos);
                }
                case 32: {
                    return PlanImage.getInt(t, pos);
                }
                case 64: {
                    return PlanImage.getLong(t, pos);
                }
                case -32: {
                    return PlanImage.getFloat(t, pos);
                }
                case -64: {
                    return PlanImage.getDouble(t, pos);
                }
            }
            return Double.NaN;
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    private int getLevelImage(long nside, long tileWidth) {
        long nbPix = 12L * nside * nside;
        long nbNeedTiles = nbPix / (tileWidth * tileWidth);
        if (nbNeedTiles < 1L) {
            return -1;
        }
        long nsideTile = (long)Math.sqrt(nbNeedTiles / 12L);
        return (int)CDSHealpix.log2(nsideTile);
    }

    private int getBitpixFromFormat(char t) throws Exception {
        int bitpix;
        int n = t == 'B' ? 8 : (t == 'I' ? 16 : (t == 'J' ? 32 : (t == 'K' ? 64 : (t == 'E' ? -32 : (bitpix = t == 'D' ? -64 : 0)))));
        if (bitpix == 0) {
            throw new Exception("Unsupported data type => [" + t + "]");
        }
        return bitpix;
    }

    @Override
    public boolean isAlreadyDone() {
        return false;
    }
}

